nVet = 500:100:900;
CDalone = [0.3144	0.3810	0.4292	0.4654	0.4941]; 

dCDfront = [0.25	0.0202	-0.0083	-0.014	-0.0303	-0.0296
            0.5	-0.0105	-0.0454	-0.0657	-0.0792	-0.0924
            0.75	0.0017	-0.0324	-0.044	-0.0516	-0.0646
            1.0	0.0177	-0.0019	-0.0105	-0.0221	-0.029
            1.5	0.0387	0.0165	0.0087	0.0058	0.0042
            2.0	0.052	0.0378	0.0266	0.0196	0.015
            3.0	0.0155	0.009	0.0079	0.0049	0.0026
            4.0	0.0165	0.0101	0.0032	0.002	0.0011
            5.0	0.0147	0.0055	0.0055	0	-0.0008
            6.0	0.012	0.0059	0.0026	-0.0002	-0.0018
            7.0	0.0088	0.0026	0.0018	-0.0022	-0.003
            9.27	0.0063	-0.0024	-0.0029	-0.0053	-0.0056];
dCDfront(:,1) = -dCDfront(:,1);

dCDrear = [0 zeros(1,5)
        0.25	-0.1529	-0.1827	-0.2007	-0.2144	-0.2194
        0.5	-0.1423	-0.1744	-0.1945	-0.2076	-0.2159
        0.75	-0.0833	-0.1027	-0.1246	-0.144	-0.1627
        1.0	-0.0887	-0.1103	-0.1426	-0.1563	-0.1643
        1.5	-0.1122	-0.1334	-0.1466	-0.1555	-0.164
        2.0	-0.1008	-0.1248	-0.1375	-0.1458	-0.1564
        3.0	-0.0951	-0.1131	-0.122	-0.1315	-0.1349
        3.5	-0.0602	-0.0858	-0.0998	-0.1131	-0.1219
        4.15	-0.0504	-0.0746	-0.0896	-0.1031	-0.114];

dCD = [flipud(dCDfront); dCDrear];
interpPlatoon = @(n,d) CDalone(nVet==n)+[0 dCD(dCD(:,1)==d,[nan nVet]==n)];

figure
subplot(2,1,1)
fro=plot( -dCDfront(:,1),dCDfront(:,2:end)./CDalone*100,'-o',...
       'MarkerFaceColor','auto');
hold on
xlim([-0.2 10]), xtickangle(45)
xlabel('d/L')
ylabel('\DeltaC_D / C_D_{ ISOLATED}')
ytickformat('percentage')
title('Front Platooning')
subplot(2,1,2)
rea=plot(dCDrear(2:end,1),dCDrear(2:end,2:end)./CDalone*100,'-o',...
       'MarkerFaceColor','auto');
   
xlim([-0.2 10]), xtickangle(45)
[rea.Color] = deal(fro.Color);

% for i=1:length(rea)
% text(0,CDalone(i),'---','Color',rea(i).Color);
% end

set(gcf,'Color','w')
title('Rear Platooning')
xlabel('d/L')
ylabel('\DeltaC_D / C_D_{ ISOLATED}')
ytickformat('percentage')
hold on


Us = [7.2251    8.0033    8.8091    9.6634  10.5917];
load fromcerutti.mat
subplot(2,1,1)
plot(mat.x,mat.z(1,:),':ok')
xticks( sort(abs(dCD(dCD(:,1)<=0,1) ) ))
text(9.27, -30, {'Maximum Allowed Space';'behind Truck'},'hor','right') 

ll1 = legend( ["U = "+round(Us,2)+" [m/s], present work ",...
       "U = ~9 [m/s], from Cerutti et Al."]);

subplot(2,1,2)
plot(mat.x,mat.z(2,:),':ok','displ','Re=.. , Cerutti et Al.')
xticks( sort(abs(dCD(dCD(:,1)>=0,1) ) ))
text(4.15, -60, {'Maximum Allowed Space';'ahead Truck'},'hor','left') 
ll2 = legend( ["U = "+round(Us,2)+" [m/s], present work ",...
       "U = ~9 [m/s], from Cerutti et Al."]);
